/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class IndexFileJob
extends IndexRequestJob {
    public IndexFileJob(String name, URI containerURI) {
        super(name, containerURI);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        try {
            IFileStore file = EFS.getStore((URI)this.getContainerURI());
            sub.worked(2);
            Set<String> documents = index.queryDocumentNames(null);
            sub.worked(3);
            long timestamp = 0L;
            if (!CollectionsUtil.isEmpty(documents)) {
                timestamp = index.getIndexFile().lastModified();
            }
            sub.worked(2);
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                if (file.fetchInfo(0, (IProgressMonitor)sub.newChild(3)).getLastModified() >= timestamp) {
                    this.indexFileStores(index, CollectionsUtil.newSet((Object[])new IFileStore[]{file}), (IProgressMonitor)sub.newChild(90));
                }
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while saving an index", (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }
}

